#include <iostream>
#include <queue>
#include <vector>
#include <algorithm>

using namespace std;

typedef unsigned long long ull;

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);
  
  int n; cin>>n;

  vector<tuple<ull, ull, ull>> vec(n);
  vector<ull> x(n), y(n), min(n, -1);

  for (int i = 0; i < n; ++i){
    cin>>x[i];
  }

  for (int i = 0; i < n; ++i){
    cin>>y[i];
  }

  for (int i = 0; i < n; ++i){
    vec[i] = make_tuple(x[i], y[i], i);
  }

  sort(vec.begin(), vec.end());

  for (int i = 0; i < n; ++i){
    x[i] = get<0>(vec[i]);
    y[i] = get<1>(vec[i]);
  }

  priority_queue<pair<ull, ull>, vector<pair<ull, ull>>, greater<pair<ull, ull>>> queue;

  queue.push({y[0], 0});

  for (int i = 1; i < n; ++i){
    ull pointO = (x[i] + y[i - 1] - x[i - 1] - y[i]) / 2;
    ull pointH = y[i - 1] - pointO;

    while (!queue.empty()){
      auto p = queue.top();

      if (p.first > y[i - 1])
        break;
      
      queue.pop();

      ull xP = x[p.second];
      ull yP = y[p.second];

      ull xI = x[i];

      if (y[i] - yP <= x[i] - (x[i - 1] + pointO))
        xI = x[i] - (y[i] - yP);

      if (min[p.second] == -1 || xI - xP < min[p.second])
        min[p.second] = xI - xP;
    }

    queue.push({y[i], i});
  }

  while (!queue.empty()) queue.pop();

  queue.push({y[n - 1], n - 1});

  for (int i = n - 2; i >= 0; --i){
    ull pointO = (x[i + 1] + y[i] - x[i] - y[i + 1]) / 2;
    ull pointH = y[i] - pointO;

    while (!queue.empty()){
      auto p = queue.top();

      if (p.first > y[i])
        break;
      
      queue.pop();

      ull xP = x[p.second];
      ull yP = y[p.second];

      ull xI = x[i];

      if (y[i] - yP <= pointO)
        xI = x[i] + (y[i] - yP);

      if (min[p.second] == -1 || xP - xI < min[p.second])
        min[p.second] = xP - xI;
    }

    queue.push({y[i], i});
  }

  vector<ull> res(n);
  
  for (int i = 0; i < n; ++i){
    res[get<2>(vec[i])] = min[i];
  }

  for (ull i = 0; i < n; ++i)
    cout<<res[i]<<'\n';

  return 0;
}